// By EVOLVED
// www.evolved-software.com

#include "Settings.fx"

//--------------
// un-tweaks
//--------------
   float4x4 ViewProj:ViewProjection;
   float4x4 View:View;
   float4x4 ViewInv:ViewInverse;
   float4x4 PrevViewProj;

//--------------
// tweaks
//--------------
   float4 CameraPosition;
   float4 ViewSize;
   float4 FogColor;
   float3 FogDensity;
   float4 FogHeight;
   float4 FogHeightColor;
   float3 AmbientSky;
   float3 AmbientGround;
   float3 LightingRange;
   float3 LightingTexture;
   float3 ReflectionColor;
   float3 LightDirection;
   float3 LightDirectionColor;
   float4 ShadowNoise;
   float4 ShadowBlur;
   float3 ShadowBlurSplit;
   float4x4 ShadowProj;
   float3 ShadowDirection;
   float4 ShadowPosition;
   float4 ShadowRanges;
   float4x4 ShadowProjection;
   float3 ShadowProjPos1;
   float3 ShadowProjPos2;
   float3 ShadowProjPos3;
   float3 ShadowPositionX;
   float3 ShadowPositionY;
   float3 ShadowPositionZ;
   float4x4 VarianceShadowProjection;
   float3 VarianceShadowPosition;
   float4 VariancePosition;
   float Normalz;
   float2 Aspect;
   float ShadowSize;

//--------------
// Textures
//--------------
   texture BaseTexture <string Name = "";>;    
   sampler BaseSampler=sampler_state
      {
         Texture=<BaseTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=Linear;
      };
   texture PixelTexture <string Name = "";>;
   sampler PixelSampler=sampler_state
      {
         Texture=<PixelTexture>;
         MagFilter=None;
         MinFilter=None;
         MipFilter=None;
      };
   texture ColorTexture <string Name = "";>;
   sampler ColorSampler=sampler_state
      {
         Texture=<ColorTexture>;
         MagFilter=None;
         MinFilter=None;
         MipFilter=None;
      };
   texture LightTexture <string Name="";>;
   sampler LightSampler=sampler_state
      {
	 Texture=<LightTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=Linear;
      };
   texture LightDataTexture <string Name = "";>;	
   sampler LightDataSampler = sampler_state 
      {
 	 Texture=<LightDataTexture>;
  	 MagFilter=None;
	 MinFilter=None;
	 MipFilter=None;
      	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };
   texture Shadow1Texture <string Name = "";>;	
   sampler Shadow1Sampler=sampler_state
      {
 	 Texture=<Shadow1Texture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=Linear;
         AddressU=Border;
         AddressV=Border;
         AddressW=Border;
         BorderColor=16646655;
      };
   texture Shadow2Texture <string Name = "";>;	
   sampler Shadow2Sampler=sampler_state
      {
 	 Texture=<Shadow2Texture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=Linear;
	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };
   texture Shadow3Texture <string Name = "";>;	
   sampler Shadow3Sampler=sampler_state
      {
 	 Texture=<Shadow3Texture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=Linear;
      	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };

//--------------
// Functions
//--------------
   #include "Tile Count.fx"
   #include "Tile Array.fx"
   #include "Spot Light.fx"
   #include "Vertex Fog.fx"
   #include "Vertex Ambient.fx"

//--------------
// structs 
//--------------
   struct InPut
      {
         float3 Pos:POSITION;        
         float2 Tex0:TEXCOORD0;
         float2 Tex1:TEXCOORD1;
         float2 Tex2:TEXCOORD2;
         float2 Tex3:TEXCOORD3;
         float2 Tex4:TEXCOORD4;
         float2 Tex5:TEXCOORD5;
         float2 Tex6:TEXCOORD6;
         float3 Color:COLOR0;
      };
   struct OutPut
      {
         float4 Pos:POSITION;
         float4 Tex:TEXCOORD0;
         float4 Project:TEXCOORD1;
         float Frame:TEXCOORD2;
         float4 Color:TEXCOORD3;
         float4 Lighting:TEXCOORD4;
         float4 FogVec:TEXCOORD5;
         float4 Ambient:COLOR0;
      };

//--------------
// vertex shader
//--------------
   OutPut VS_Lighting(InPut IN) 
      {
         OutPut OUT;
         float2 Pixel=floor(float2(IN.Pos.z,IN.Pos.z/254.0));
         Pixel=float2((Pixel.x-Pixel.y*254.0)-256.0,Pixel.y+256.0)*0.00390625;
         float4 Particle=tex2Dlod(PixelSampler,float4(0.5+Pixel.x*0.5,Pixel.y,0.0,0.0));
         float3 WorldPos=Particle.xyz*IN.Tex5.x;
         float3 Curve=tex2Dlod(ColorSampler,float4(0.5+Particle.w*0.5,IN.Tex6.x/1024.0,0,0));
         float2 Size=(IN.Pos.xy*IN.Tex1.x)*Curve.y;
         float Strobe=saturate(sin(Particle.w*IN.Tex4.x*2.0).xx+0.5);
         Size +=Strobe*(IN.Pos.xy*IN.Tex3.y)*Curve.z;
         float4 CurrPos=mul(float4(Particle.xyz*IN.Tex5.x,1.0),ViewProj);
         Size *=1.0+CurrPos.z*IN.Tex2.x;
         float3 DSin, DCos;
         sincos(float3(IN.Tex3,IN.Tex5.y),DSin,DCos);
         float3 DSin2=DSin*2.0;
         float3x3 XRotateAxis=float3x3(1.0,0.0,0.0,0.0,1.0-(DSin.x*DSin2.x),-(DCos.x*DSin2.x),0.0,DCos.x*DSin2.x,1.0-(DSin.x*DSin2.x));
         float3x3 YRotateAxis=float3x3(1.0-(DSin.y*DSin2.y),0.0,DCos.y*DSin2.y,0.0,1.0,0.0,-(DCos.y*DSin2.y),0.0,1.0-(DSin.y*DSin2.y));
         float3x3 ZRotateAxis=float3x3(1.0-(DSin.z*DSin2.z),-(DCos.z*DSin2.z),0.0,DCos.z*DSin2.z,1.0-(DSin.z*DSin2.z),0.0,0.0,0.0,1.0);
         WorldPos +=mul(mul(mul(float3(-Size.x*IN.Tex5.x,Size.y*IN.Tex5.x,0),ZRotateAxis),XRotateAxis),YRotateAxis);
         OUT.Pos=mul(float4(WorldPos*saturate(ceil(Particle.w)),1.0),ViewProj);
         float2 UV=0.5+float2(IN.Pos.x,-IN.Pos.y)*0.5;
         float FrameTime=IN.Tex0.x*IN.Tex0.y;
         FrameTime *=Particle.w*(1.0-(1.0/FrameTime));
         OUT.Tex.xy=(UV/IN.Tex0.xy)+(float2(int(FrameTime),int(FrameTime/IN.Tex0.x))/IN.Tex0);
         OUT.Tex.zw=(UV/IN.Tex0.xy)+(float2(int(FrameTime+1),int((FrameTime+1)/IN.Tex0.x))/IN.Tex0);
         OUT.Frame=FrameTime-floor(FrameTime);
         float4 Project=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z*0.5,OUT.Pos.w);
         OUT.Project=Project;
         Project.xy /=Project.w;
         OUT.Color=tex2Dlod(ColorSampler,float4(Particle.w*0.5,(IN.Tex6.x+0.5)/1024.0,0.0,0.0));
         OUT.Color.xyz=pow(OUT.Color.xyz+IN.Color,2.2);
         float ViewDepth=length(ViewInv[3].xyz-WorldPos.xyz);
         float4 WorldCamPos=float4(WorldPos,0.0)-CameraPosition;
         OUT.Lighting.xyz=LightDirectionColor*2.0;
         #if Shadows == 1
          float2 ShadowProj=mul(float4(WorldPos-ShadowProjPos3,1.0),ShadowProjection/ShadowRanges.z*2.0)*float2(0.5,-0.5)+0.5;
          float Depth=dot(WorldPos.xyz-float3(ShadowPositionX.z,ShadowPositionY.z,ShadowPositionZ.z),ShadowDirection)/ShadowRanges.z;
          float4 ShadowMap=float4(tex2Dlod(Shadow1Sampler,ShadowProj.xyyy).z,tex2Dlod(Shadow1Sampler,ShadowProj.xyyy+float4(1.0/ShadowSize,0.0,0.0,0.0)).z,
                                  tex2Dlod(Shadow1Sampler,ShadowProj.xyyy+float4(0,1.0/ShadowSize,0.0,0.0)).z,tex2Dlod(Shadow1Sampler,ShadowProj.xyyy+float4(1.0/ShadowSize,1.0/ShadowSize,0.0,0.0)).z);
          ShadowMap=saturate(step(saturate(Depth),ShadowMap));
          ShadowMap.xy=lerp(ShadowMap.xz,ShadowMap.yw,frac(ShadowSize*ShadowProj.x));
          OUT.Lighting.xyz *=lerp(ShadowMap.x,ShadowMap.y,frac(ShadowSize*ShadowProj.y));
         #endif
         float Index=floor(Project.x*16.0)+floor(Project.y*8.0)*16.0;
         int2 Tiles=TileCount(Project*float2(0.0625,0.03125),ViewDepth/LightingRange.x);
         for(int i=0; i<Tiles.x; i++ ) {
          float4 TileArray=float4(TileArray(i+128.0,Index,Tiles.y)+0.001953125,0.97265625,0.0,0.0);
          float4 LightPosition=tex2Dlod(LightDataSampler,TileArray)-WorldCamPos;
          float4 LightColor=tex2Dlod(LightDataSampler,TileArray+float4(0.0,0.00390625,0.0,0.0));
          float4 LightSpot=tex2Dlod(LightDataSampler,TileArray+float4(0.0,0.0078125,0.0,0.0));
          float Attenuation=length(LightPosition.xyz);
          float3 LightVec=LightPosition.xyz/Attenuation;
          float3 Light=LightColor.xyz*max(1.0/(Attenuation/LightPosition.w)-1.0,0.0);
          OUT.Lighting.xyz +=Light*SpotLight(LightVec,LightSpot.xyz,float2(LightSpot.w,LightColor.w));
         }
         OUT.Lighting.w=IN.Tex4.y*Curve.x;
         OUT.Ambient.xyz=lerp(AmbientGround,AmbientSky,0.5)*2.0;
         float LightSegment=clamp(floor((ViewDepth/LightingRange.z)*16.0),0.0,15.0)*0.00390625;
         int LightCount=tex2Dlod(LightDataSampler,float4(0.12890625,LightSegment,0.0,0.0));
         float4 AmbientLighting=0.0;
         for (int l=0; l < LightCount; l++) {
          AmbientLighting=max(VertexAmbient((34.0+l)*0.00390625,LightSegment,WorldCamPos),AmbientLighting);
         }
         OUT.Ambient.xyz=lerp(OUT.Ambient.xyz,AmbientLighting.xyz,AmbientLighting.w);
         OUT.Ambient.w=0.0;
         float3 ViewVec=normalize(ViewInv[3].xyz-WorldPos.xyz);
         OUT.FogVec=VertexFog(ViewDepth,WorldPos,ViewVec,LightDirection,LightDirectionColor,FogColor,FogDensity,FogHeightColor,FogHeight);
         return OUT;
      }
   OutPut VS_Distortion(InPut IN) 
      {
         OutPut OUT;
         float2 Pixel=floor(float2(IN.Pos.z,IN.Pos.z/254.0));
         Pixel=float2((Pixel.x-Pixel.y*254.0)-256.0,Pixel.y+256.0)*0.00390625;
         float4 Particle=tex2Dlod(PixelSampler,float4(0.5+Pixel.x*0.5,Pixel.y,0.0,0.0));
         float3 WorldPos=Particle.xyz*IN.Tex5.x;
         float3 Curve=tex2Dlod(ColorSampler,float4(0.5+Particle.w*0.5,IN.Tex6.x/1024.0,0,0));
         float2 Size=(IN.Pos.xy*IN.Tex1.x)*Curve.y;
         float Strobe=saturate(sin(Particle.w*IN.Tex4.x).xx+0.5);
         Size +=Strobe*(IN.Pos.xy*IN.Tex3.y)*Curve.z;
         float3 DSin,DCos;
         sincos(float3(IN.Tex3,IN.Tex5.y),DSin,DCos);
         float3 DSin2=DSin*2.0;
         float3x3 XRotateAxis=float3x3(1.0,0.0,0.0,0.0,1.0-(DSin.x*DSin2.x),-(DCos.x*DSin2.x),0.0,DCos.x*DSin2.x,1.0-(DSin.x*DSin2.x));
         float3x3 YRotateAxis=float3x3(1.0-(DSin.y*DSin2.y),0.0,DCos.y*DSin2.y,0.0,1.0,0.0,-(DCos.y*DSin2.y),0.0,1.0-(DSin.y*DSin2.y));
         float3x3 ZRotateAxis=float3x3(1.0-(DSin.z*DSin2.z),-(DCos.z*DSin2.z),0.0,DCos.z*DSin2.z,1.0-(DSin.z*DSin2.z),0.0,0.0,0.0,1.0);
         WorldPos +=mul(mul(mul(float3(-Size.x*IN.Tex5.x,Size.y*IN.Tex5.x,0),ZRotateAxis),XRotateAxis),YRotateAxis);
         OUT.Pos=mul(float4(WorldPos*saturate(ceil(Particle.w)),1.0),ViewProj);
         float2 UV=0.5+float2(IN.Pos.x,-IN.Pos.y)*0.5;
         float FrameTime=IN.Tex0.x*IN.Tex0.y;
         FrameTime *=Particle.w*(1.0-(1.0/FrameTime));
         OUT.Tex.xy=(UV/IN.Tex0.xy)+(float2(int(FrameTime),int(FrameTime/IN.Tex0.x))/IN.Tex0);
         OUT.Tex.zw=(UV/IN.Tex0.xy)+(float2(int(FrameTime+1.0),int((FrameTime+1.0)/IN.Tex0.x))/IN.Tex0);
         OUT.Project=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z*0.5,OUT.Pos.w);
         OUT.Frame=FrameTime-floor(FrameTime);
         OUT.Color=tex2Dlod(ColorSampler,float4(Particle.w*0.5,(IN.Tex6.x+0.5)/1024.0,0.0,0.0));
         OUT.Lighting=0.0;
         OUT.FogVec=0.0;
         OUT.Ambient=0.0;
         return OUT;
      }

//--------------
// pixel shader
//--------------
   float4 PS_Lighting(OutPut IN)  : COLOR
      {
         float4 Particle=lerp(tex2D(BaseSampler,IN.Tex.xy),tex2D(BaseSampler,IN.Tex.zw),IN.Frame);
         Particle.xyz=pow(Particle.xyz,2.2)*IN.Color.xyz;
         Particle.xyz=Particle.xyz*(IN.Ambient.xyz+IN.Lighting.xyz)+Particle.xyz*IN.Lighting.w;
         return float4(lerp(Particle.xyz,IN.FogVec.xyz,IN.FogVec.w),Particle.w*IN.Color.w);
      }
   float4 PS_Distortion(OutPut IN)  : COLOR
      {
         IN.Color.w *=saturate(tex2D(Shadow3Sampler,(IN.Project.xy/IN.Project.w)+ViewSize).w-IN.Project.z);
         float2 Distortion=lerp(tex2D(LightSampler,IN.Tex.xy),tex2D(LightSampler,IN.Tex.zw),IN.Frame)*2.0-1.0;
         return float4(0.50196078431+Distortion*0.5,1.0,1.0)*lerp(tex2D(BaseSampler,IN.Tex.xy).w,tex2D(BaseSampler,IN.Tex.zw).w,IN.Frame)*IN.Color.w;
      }

//--------------
// techniques   
//--------------
   technique Lighting
      {
         pass p0
      {      
         vertexShader= compile vs_3_0 VS_Lighting();
         pixelShader = compile ps_3_0 PS_Lighting();
         ColorWriteEnable=7;
         AlphaBlendEnable=true;
         AlphaTestEnable=false;
         zwriteenable=false;
      }
      }
   technique Distortion
      {
         pass p1
      {
         vertexShader = compile vs_3_0 VS_Distortion();
         pixelShader  = compile ps_3_0 PS_Distortion();
         ColorWriteEnable=15;
         AlphaBlendEnable=true;
         SrcBlend=One;
         DestBlend=InvSrcAlpha;
         AlphaTestEnable=true;
  	 AlphaRef=16;
         zwriteenable=false;
      }
      }
